"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBookingLeadOverview = exports.getTop5Bookings = exports.getOperationDashboardData = void 0;
const operationDashboardService_1 = require("../../services/user/operationDashboardService");
const operationDashboardService = new operationDashboardService_1.OperationDashboardService();
const getOperationDashboardData = async (req, res) => {
    try {
        const userId = req.currentUser; // Get user ID from authentication middleware
        const dashboardData = await operationDashboardService.getDashboardData(userId);
        res.status(200).json({ success: true, data: dashboardData });
    }
    catch (error) {
        console.error("Controller Error - getOperationDashboardData:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
exports.getOperationDashboardData = getOperationDashboardData;
const getTop5Bookings = async (req, res) => {
    try {
        const userId = req.currentUser; // Get user ID from authentication middleware
        const topBookings = await operationDashboardService.getTopBookings(userId);
        res.status(200).json({ success: true, data: topBookings });
    }
    catch (error) {
        console.error("Controller Error - getTop5Bookings:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
exports.getTop5Bookings = getTop5Bookings;
const getBookingLeadOverview = async (req, res) => {
    try {
        const timeframe = req.params.timeframe || "weekly";
        const userId = req.currentUser; // Get user ID from authentication middleware
        const bookingLeadOverviewData = await operationDashboardService.getBookingLeadOverview(timeframe, userId);
        res.status(200).json({ success: true, data: bookingLeadOverviewData });
    }
    catch (error) {
        console.error("Controller Error - getBookingLeadOverview:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
exports.getBookingLeadOverview = getBookingLeadOverview;
//# sourceMappingURL=operationDashboardController.js.map