"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAssessmentLeadOverview = exports.getAssessmentDashboardData = void 0;
const assessmentDashboardService_1 = require("../../services/user/assessmentDashboardService");
const assessmentDashboardService = new assessmentDashboardService_1.AssessmentDashboardService();
const getAssessmentDashboardData = async (req, res) => {
    try {
        const userId = req.currentUser; // Get user ID from authentication middleware
        const dashboardData = await assessmentDashboardService.getDashboardData(userId);
        res.status(200).json({ success: true, data: dashboardData });
    }
    catch (error) {
        console.error("Controller Error - getAssessmentDashboardData:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
exports.getAssessmentDashboardData = getAssessmentDashboardData;
const getAssessmentLeadOverview = async (req, res) => {
    try {
        const timeframe = req.params.timeframe || "weekly";
        const userId = req.currentUser; // Get user ID from authentication middleware
        const bookingLeadOverviewData = await assessmentDashboardService.getAssessmentLeadOverview(timeframe, userId);
        res.status(200).json({ success: true, data: bookingLeadOverviewData });
    }
    catch (error) {
        console.error("Controller Error - getBookingLeadOverview:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
exports.getAssessmentLeadOverview = getAssessmentLeadOverview;
//# sourceMappingURL=assessmentDashboardController.js.map