"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDashboardController = void 0;
class UserDashboardController {
    constructor(userDashboardService) {
        this.userDashboardService = userDashboardService;
    }
    async getUserDashboardData(req, res, next) {
        var _a, _b, _c;
        try {
            // Extract from decoded JWT
            const teamId = (_a = req.decoded) === null || _a === void 0 ? void 0 : _a.teamId;
            const empCode = (_b = req.decoded) === null || _b === void 0 ? void 0 : _b.userId;
            console.log("Decoded JWT:", req.decoded);
            console.log("Team ID:", teamId, "Employee Code:", empCode);
            const role = (_c = req.decoded) === null || _c === void 0 ? void 0 : _c.role;
            console.log("User Role:", role);
            if (!teamId) {
                res.status(400).json({
                    success: false,
                    message: "Missing teamId",
                });
                return;
            }
            if (!empCode) {
                res.status(400).json({
                    success: false,
                    message: "Missing empCode in token",
                });
                return;
            }
            const dashboardData = await this.userDashboardService.getDashboardData(teamId, empCode);
            res.status(200).json({ success: true, data: dashboardData });
        }
        catch (error) {
            console.error("Controller Error - getUserDashboardData:", error);
            next(error); // Use next to send to global error handler
        }
    }
}
exports.UserDashboardController = UserDashboardController;
//# sourceMappingURL=UserDashboardController.js.map