"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierController = void 0;
const supplierService_1 = require("../services/supplierService");
const supplierService = new supplierService_1.SupplierService();
class SupplierController {
    createSupplier(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const supplier = yield supplierService.createSupplier(req.body);
                res.status(201).json(supplier);
            }
            catch (error) {
                console.error("Error creating supplier:", error);
                res.status(500).json({ message: error.message || "An unknown error occurred" });
            }
        });
    }
    getSuppliers(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const suppliers = yield supplierService.getSuppliers();
                if (!suppliers || suppliers.length === 0) {
                    return res.status(404).json({ message: "No suppliers found" });
                }
                res.json(suppliers);
            }
            catch (error) {
                console.error("Error getting suppliers:", error);
                res.status(500).json({ message: error.message || "An unknown error occurred" });
            }
        });
    }
    getSupplierById(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id; // Explicitly type `id`
                const supplier = yield supplierService.getSupplierById(id);
                if (!supplier) {
                    return res.status(404).json({ message: "Supplier not found" });
                }
                res.json(supplier);
            }
            catch (error) {
                console.error("Error getting supplier by ID:", error);
                res.status(500).json({ message: error.message || "An unknown error occurred" });
            }
        });
    }
    updateSupplier(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id; // Explicitly type `id`
                const supplier = yield supplierService.updateSupplier(id, req.body);
                if (!supplier) {
                    return res.status(404).json({ message: "Supplier not found" });
                }
                res.json(supplier);
            }
            catch (error) {
                console.error("Error updating supplier:", error);
                // Check for specific Prisma errors here if you want (e.g., record not found)
                res.status(500).json({ message: error.message || "An unknown error occurred" });
            }
        });
    }
    deleteSupplier(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id; // Explicitly type `id`
                yield supplierService.deleteSupplier(id);
                res.json({ message: "Supplier deleted successfully" });
            }
            catch (error) {
                console.error("Error deleting supplier:", error);
                // Check for specific Prisma errors here if you want (e.g., record not found)
                res.status(500).json({ message: error.message || "An unknown error occurred" });
            }
        });
    }
}
exports.SupplierController = SupplierController;
