"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelController = void 0;
const hotelService_1 = require("../services/hotelService");
class HotelController {
    constructor() {
        this.createHotel = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const hotel = yield this.hotelService.createHotel(req.body);
                res.status(201).json(hotel);
            }
            catch (error) {
                next(error);
            }
        });
        this.getHotels = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const hotels = yield this.hotelService.getHotels();
                res.json(hotels);
            }
            catch (error) {
                next(error);
            }
        });
        this.getHotelById = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const hotel = yield this.hotelService.getHotelById(req.params.id);
                if (!hotel) {
                    res.status(404).json({ message: "Hotel not found" });
                }
                res.json(hotel);
            }
            catch (error) {
                next(error);
            }
        });
        this.updateHotel = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const hotel = yield this.hotelService.updateHotel(req.params.id, req.body);
                res.json(hotel);
            }
            catch (error) {
                next(error);
            }
        });
        this.deleteHotel = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.hotelService.deleteHotel(req.params.id);
                res.json({ message: "Hotel deleted successfully" });
            }
            catch (error) {
                next(error);
            }
        });
        this.hotelService = new hotelService_1.HotelService();
    }
}
exports.HotelController = HotelController;
