"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.markNotificationAsRead = exports.markAllNotificationsAsRead = exports.getUserNotifications = exports.getAdminNotifications = void 0;
const notificationService_1 = require("../../services/common/notificationService");
const notificationService = new notificationService_1.NotificationService();
const getAdminNotifications = async (req, res) => {
    try {
        const notifications = await notificationService.getAdminNotifications();
        res.json(notifications);
    }
    catch (error) {
        console.error("Error fetching admin notifications:", error);
        res.status(500).json({ message: "Failed to fetch notifications" });
    }
};
exports.getAdminNotifications = getAdminNotifications;
const getUserNotifications = async (req, res) => {
    var _a;
    try {
        const userId = (_a = req.decoded) === null || _a === void 0 ? void 0 : _a.userId; // Assuming user ID is passed as a URL parameter
        const notifications = await notificationService.getUserNotifications(userId);
        res.json(notifications);
    }
    catch (error) {
        console.error("Error fetching user notifications:", error);
        res.status(500).json({ message: "Failed to fetch user notifications" });
    }
};
exports.getUserNotifications = getUserNotifications;
const markAllNotificationsAsRead = async (req, res) => {
    try {
        const notification = await notificationService.markAllAsReadForAdmin();
        res.json(notification);
    }
    catch (error) {
        console.error("Error marking all notifications as read:", error);
        res.status(500).json({ message: "Failed to mark all notifications as read" });
    }
};
exports.markAllNotificationsAsRead = markAllNotificationsAsRead;
const markNotificationAsRead = async (req, res) => {
    try {
        const notification = await notificationService.markAsRead(req.params.id);
        res.json(notification);
    }
    catch (error) {
        console.error("Error marking notification as read:", error);
        res.status(500).json({ message: "Failed to mark notification as read" });
    }
};
exports.markNotificationAsRead = markNotificationAsRead;
//# sourceMappingURL=notificationController.js.map