"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.refreshAccessToken = void 0;
const dotenv_1 = __importDefault(require("dotenv"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
dotenv_1.default.config();
const SECRET_KEY = process.env.JWT_SECRET;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET;
const refreshAccessToken = async (req, res, next) => {
    try {
        const refreshToken = req.headers["x-refresh-token"];
        if (!refreshToken) {
            res
                .status(401)
                .json({ success: false, message: "Refresh token missing" });
            return;
        }
        const payload = jsonwebtoken_1.default.verify(refreshToken, REFRESH_SECRET);
        if (typeof payload !== "object" || payload === null) {
            throw new Error("Invalid token payload");
        }
        // You can validate payload.id
        const newAccessToken = jsonwebtoken_1.default.sign({ id: payload.id }, SECRET_KEY, {
            expiresIn: "7d",
        });
        res.setHeader("x-access-token", newAccessToken);
        res.status(200).json({
            success: true,
            message: "Access token refreshed",
            accessToken: newAccessToken,
        });
    }
    catch (error) {
        console.error("Refresh Token Error:", error);
        res
            .status(403)
            .json({ success: false, message: "Invalid or expired refresh token" });
    }
};
exports.refreshAccessToken = refreshAccessToken;
//# sourceMappingURL=authController.js.map