"use strict";
// backend/src/controllers/agentLoginController.ts
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.agentLoginController = void 0;
const console_1 = __importDefault(require("console"));
const agentLoginService_1 = require("../../services/agent/agentLoginService");
const agentLoginController = async (req, res, next) => {
    try {
        const { username, password } = req.body;
        if (!username || !password) {
            res.status(400).json({
                success: false,
                message: "Username and password are required.",
            });
            return;
        }
        const { accessToken, refreshToken, credentials } = await (0, agentLoginService_1.agentLogin)({
            username,
            password,
        });
        const agent = credentials.agent;
        console_1.default.log("🧾 Full AgentCredentials in controller:", credentials);
        res.status(200).json({
            success: true,
            message: "Agent login successful.",
            accessToken,
            refreshToken,
            user: {
                id: agent === null || agent === void 0 ? void 0 : agent.id,
                name: (agent === null || agent === void 0 ? void 0 : agent.companyName) || (agent === null || agent === void 0 ? void 0 : agent.contactPerson) || (agent === null || agent === void 0 ? void 0 : agent.email),
                email: agent === null || agent === void 0 ? void 0 : agent.email,
                role: agent === null || agent === void 0 ? void 0 : agent.role,
                phone: agent === null || agent === void 0 ? void 0 : agent.phone,
                agentCode: agent === null || agent === void 0 ? void 0 : agent.agentCode,
                contactPerson: agent === null || agent === void 0 ? void 0 : agent.contactPerson,
                // markup: agent?.markup,
                companyName: agent === null || agent === void 0 ? void 0 : agent.companyName,
                companyAddress: agent === null || agent === void 0 ? void 0 : agent.companyAddress,
                designation: agent === null || agent === void 0 ? void 0 : agent.designation,
                state: agent === null || agent === void 0 ? void 0 : agent.state,
                // Include credentials info in response
                credentials: {
                    id: credentials.id,
                    username: credentials.username,
                    filename: credentials.filename,
                    password: credentials.password, // Optional: omit this if sensitive
                },
            },
        });
    }
    catch (error) {
        console_1.default.error("🚨 Agent login error:", error);
        next(error);
    }
};
exports.agentLoginController = agentLoginController;
//# sourceMappingURL=agentLoginController.js.map