"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentLeadController = void 0;
class AgentLeadController {
    constructor(agentLeadService) {
        this.agentLeadService = agentLeadService;
    }
    async createLead(req, res, next) {
        try {
            const agentId = req.currentUser;
            if (!agentId) {
                res
                    .status(401)
                    .json({ message: "Unauthorized: Missing agentId in token" });
                return;
            }
            const newLeadData = { ...req.body, agentId };
            const createdLead = await this.agentLeadService.createLead(newLeadData);
            res.status(201).json(createdLead);
        }
        catch (error) {
            next(error);
        }
    }
    async getAllLeads(req, res, next) {
        try {
            const agentId = req.currentUser;
            console.log("Agent ID from JWT", agentId);
            if (!agentId) {
                res.status(401).json({ message: "Unauthorized: Missing agentId in token" });
                return;
            }
            const leads = await this.agentLeadService.getLeads(agentId);
            console.log("Leads fetched successfully:", leads);
            res.json(leads);
        }
        catch (error) {
            console.error("Error fetching all leads:", error);
            next(error);
        }
    }
    async getLeadById(req, res, next) {
        try {
            const leadId = req.params.id;
            const agentId = req.currentUser;
            if (!agentId) {
                res
                    .status(401)
                    .json({ message: "Unauthorized: Missing agentId in token" });
                return;
            }
            const lead = await this.agentLeadService.getLeadById(leadId, agentId);
            if (!lead) {
                res
                    .status(404)
                    .json({ message: "Lead not found or not owned by agent" });
                return;
            }
            res.json(lead);
        }
        catch (error) {
            next(error);
        }
    }
    async updateLead(req, res, next) {
        try {
            const leadId = req.params.leadId;
            const agentId = req.currentUser;
            if (!agentId) {
                res
                    .status(401)
                    .json({ message: "Unauthorized: Missing agentId in token" });
                return;
            }
            const leadData = req.body;
            const updatedLead = await this.agentLeadService.updateLead(leadId, agentId, leadData);
            if (updatedLead) {
                res.json(updatedLead);
            }
            else {
                res.status(404).json({ message: "Lead not found or unauthorized" });
            }
        }
        catch (error) {
            console.error("Error updating lead (agent):", error);
            next(error);
        }
    }
    async deleteLead(req, res, next) {
        try {
            const leadId = req.params.leadId;
            const agentId = req.currentUser;
            if (!agentId) {
                res
                    .status(401)
                    .json({ message: "Unauthorized: Missing agentId in token" });
                return;
            }
            await this.agentLeadService.deleteLead(leadId, agentId);
            res.status(204).send();
        }
        catch (error) {
            console.error("Error deleting lead (agent):", error);
            next(error);
        }
    }
    async updateStage(req, res) {
        const { id } = req.params;
        console.log("REq body in controller", req.body);
        const { stage, notes, userName } = req.body;
        console.log("REq body in controller", req.body);
        try {
            const lead = await this.agentLeadService.changeStage(id, stage, userName, notes);
            if (!lead)
                return res.status(404).json({ message: "Lead not found" });
            return res.status(200).json(lead);
        }
        catch (err) {
            return res.status(500).json({ message: "Server error", error: err });
        }
    }
}
exports.AgentLeadController = AgentLeadController;
//# sourceMappingURL=AgentLeadController.js.map