"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransferController = void 0;
const transferService_1 = require("../../services/admin/transferService");
const transferService = new transferService_1.TransferService();
class TransferController {
    async createTransfer(req, res) {
        try {
            const transfer = await transferService.createTransfer(req.body);
            res.status(201).json(transfer);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async getTransfers(req, res) {
        try {
            const transfers = await transferService.getTransfers();
            res.json(transfers);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async getTransferById(req, res) {
        try {
            const transfer = await transferService.getTransferById(req.params.id);
            if (!transfer) {
                res.status(404).json({ message: "Transfer not found" });
                return;
            }
            res.json(transfer);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async updateTransfer(req, res) {
        try {
            const transfer = await transferService.updateTransfer(req.params.id, req.body);
            res.json(transfer);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async deleteTransfer(req, res) {
        try {
            await transferService.deleteTransfer(req.params.id);
            res.json({ message: "Transfer deleted successfully" });
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
}
exports.TransferController = TransferController;
//# sourceMappingURL=transferController.js.map