"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TourController = void 0;
const tourService_1 = require("../../services/admin/tourService");
const tourService = new tourService_1.TourService();
class TourController {
    async createTour(req, res, next) {
        try {
            const tour = await tourService.createTour(req.body);
            res.status(201).json(tour);
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
    async getTours(req, res, next) {
        try {
            const tours = await tourService.getTours();
            res.json(tours);
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
    async getTourById(req, res, next) {
        try {
            const tour = await tourService.getTourById(req.params.id);
            if (!tour) {
                //Use return statement because is not error
                return res.status(404).json({ message: 'Tour not found' });
            }
            res.json(tour);
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
    async updateTour(req, res, next) {
        try {
            const tour = await tourService.updateTour(req.params.id, req.body);
            res.json(tour);
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
    async deleteTour(req, res, next) {
        try {
            await tourService.deleteTour(req.params.id);
            res.json({ message: 'Tour deleted successfully' });
        }
        catch (error) {
            next(error); // Pass the error to the next middleware
        }
    }
}
exports.TourController = TourController;
//# sourceMappingURL=tourController.js.map