"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierController = void 0;
const supplierService_1 = require("../../services/admin/supplierService");
const supplierService = new supplierService_1.SupplierService();
class SupplierController {
    async createSupplier(req, res) {
        try {
            const supplier = await supplierService.createSupplier(req.body);
            res.status(201).json(supplier);
        }
        catch (error) {
            console.error("Error creating supplier:", error);
            res.status(500).json({ message: error.message || "An unknown error occurred" });
        }
    }
    async getSuppliers(req, res) {
        try {
            const suppliers = await supplierService.getSuppliers();
            return res.status(200).json(suppliers || []);
        }
        catch (error) {
            console.error("Error getting suppliers:", error);
            res.status(500).json({ message: error.message || "An unknown error occurred" });
        }
    }
    async getSupplierById(req, res) {
        try {
            const id = req.params.id; // Explicitly type `id`
            const supplier = await supplierService.getSupplierById(id);
            if (!supplier) {
                return res.status(404).json({ message: "Supplier not found" });
            }
            res.json(supplier);
        }
        catch (error) {
            console.error("Error getting supplier by ID:", error);
            res.status(500).json({ message: error.message || "An unknown error occurred" });
        }
    }
    async updateSupplier(req, res) {
        try {
            const id = req.params.id; // Explicitly type `id`
            const supplier = await supplierService.updateSupplier(id, req.body);
            if (!supplier) {
                return res.status(404).json({ message: "Supplier not found" });
            }
            res.json(supplier);
        }
        catch (error) {
            console.error("Error updating supplier:", error);
            // Check for specific Prisma errors here if you want (e.g., record not found)
            res.status(500).json({ message: error.message || "An unknown error occurred" });
        }
    }
    async deleteSupplier(req, res) {
        try {
            const id = req.params.id; // Explicitly type `id`
            await supplierService.deleteSupplier(id);
            res.json({ message: "Supplier deleted successfully" });
        }
        catch (error) {
            console.error("Error deleting supplier:", error);
            // Check for specific Prisma errors here if you want (e.g., record not found)
            res.status(500).json({ message: error.message || "An unknown error occurred" });
        }
    }
}
exports.SupplierController = SupplierController;
//# sourceMappingURL=supplierController.js.map