"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestaurantController = void 0;
const restaurantService_1 = require("../../services/admin/restaurantService");
const restaurantService = new restaurantService_1.RestaurantService();
class RestaurantController {
    async createRestaurant(req, res) {
        try {
            const restaurant = await restaurantService.createRestaurant(req.body);
            res.status(201).json(restaurant);
        }
        catch (error) {
            console.error("Error creating restaurant:", error);
            res.status(500).json({ error: error.message });
        }
    }
    async getRestaurants(req, res) {
        try {
            const restaurants = await restaurantService.getRestaurants();
            res.json(restaurants);
        }
        catch (error) {
            console.error("Error getting restaurants:", error);
            res.status(500).json({ error: error.message });
        }
    }
    async getRestaurantById(req, res) {
        try {
            const { id } = req.params;
            const restaurant = await restaurantService.getRestaurantById(id);
            if (!restaurant) {
                return res.status(404).json({ message: "Restaurant not found" });
            }
            res.json(restaurant);
        }
        catch (error) {
            console.error("Error getting restaurant:", error);
            res.status(500).json({ error: error.message });
        }
    }
    async updateRestaurant(req, res) {
        try {
            const { id } = req.params;
            const restaurant = await restaurantService.updateRestaurant(id, req.body);
            res.json(restaurant);
        }
        catch (error) {
            console.error("Error updating restaurant:", error);
            res.status(500).json({ error: error.message });
        }
    }
    async deleteRestaurant(req, res) {
        try {
            const { id } = req.params;
            await restaurantService.deleteRestaurant(id);
            res.status(204).send(); // No content
        }
        catch (error) {
            console.error("Error deleting restaurant:", error);
            res.status(500).json({ error: error.message });
        }
    }
}
exports.RestaurantController = RestaurantController;
//# sourceMappingURL=restaurantController.js.map