import { NextFunction, Request, Response } from "express";
import { LeadService } from "../../services/admin/leadService";
export declare class LeadController {
    private leadService;
    constructor(leadService: LeadService);
    createLead(req: Request, res: Response, next: NextFunction): Promise<void>;
    getLeads(req: Request, res: Response, next: NextFunction): Promise<void>;
    getLeadById(req: Request, res: Response, next: NextFunction): Promise<void>;
    updateLead(req: Request, res: Response, next: NextFunction): Promise<void>;
    deleteLead(req: Request, res: Response, next: NextFunction): Promise<void>;
    getLeadsByTimeframe(req: Request, res: Response, next: NextFunction): Promise<void>;
    updateStatus(req: Request, res: Response): Promise<Response<any, Record<string, any>>>;
    updateStage(req: Request, res: Response): Promise<Response<any, Record<string, any>>>;
    assignLeadToOperations(req: Request, res: Response): Promise<Response<any, Record<string, any>>>;
    assignLeadToAssessment(req: Request, res: Response): Promise<Response<any, Record<string, any>>>;
    getQuotationAcceptedLeads(req: Request, res: Response): Promise<Response<any, Record<string, any>>>;
}
//# sourceMappingURL=leadController.d.ts.map