"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelController = void 0;
class HotelController {
    constructor(hotelService) {
        this.createHotel = async (req, res) => {
            try {
                const hotel = await this.hotelService.createHotel(req.body);
                res.status(201).json(hotel);
            }
            catch (error) {
                res.status(400).json({ error: error.message || "Failed to create hotel" });
            }
        };
        this.getHotels = async (req, res, next) => {
            try {
                const page = parseInt(req.query.page) || 1;
                const limit = parseInt(req.query.limit) || 10;
                const searchTerm = req.query.search || "";
                const hotels = await this.hotelService.getHotels(page, limit, searchTerm);
                res.json(hotels);
            }
            catch (error) {
                res.status(500).json({ error: error.message });
            }
        };
        this.getHotelById = async (req, res, next) => {
            try {
                const hotel = await this.hotelService.getHotelById(req.params.id);
                if (!hotel) {
                    res.status(404).json({ message: "Hotel not found" });
                }
                res.json(hotel);
            }
            catch (error) {
                next(error);
            }
        };
        this.updateHotel = async (req, res, next) => {
            try {
                const hotel = await this.hotelService.updateHotel(req.params.id, req.body);
                console.log(hotel);
                res.json(hotel);
            }
            catch (error) {
                next(error);
            }
        };
        this.deleteHotel = async (req, res, next) => {
            try {
                await this.hotelService.deleteHotel(req.params.id);
                res.json({ message: "Hotel deleted successfully" });
            }
            catch (error) {
                next(error);
            }
        };
        this.createRoom = async (req, res) => {
            try {
                const room = await this.hotelService.createRoom(req.body);
                console.log(room);
                res.status(201).json({ message: "Room created", room });
            }
            catch (error) {
                res.status(400).json({ error: error.message });
            }
        };
        this.getRoomById = async (req, res) => {
            try {
                const room = await this.hotelService.getRoomById(req.params.id);
                if (!room) {
                    res.status(404).json({ message: "Room not found" });
                }
                res.json(room);
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        };
        this.updateRoom = async (req, res) => {
            try {
                const room = await this.hotelService.updateRoom(req.params.id, req.body);
                res.json(room);
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        };
        this.deleteRoom = async (req, res) => {
            try {
                await this.hotelService.deleteRoom(req.params.id);
                res.json({ message: "Room deleted successfully" });
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        };
        this.getRoomsByHotel = async (req, res) => {
            try {
                const { hotelId } = req.params;
                if (!hotelId) {
                    res.status(400).json({ message: 'Hotel ID is required' });
                }
                const rooms = await this.hotelService.getRoomsByHotelId(hotelId);
                res.status(200).json(rooms);
            }
            catch (error) {
                res.status(500).json({ message: error.message });
            }
        };
        this.hotelService = hotelService;
    }
}
exports.HotelController = HotelController;
//# sourceMappingURL=hotelController.js.map