"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GuideController = void 0;
const guideService_1 = require("../../services/admin/guideService");
const guideService = new guideService_1.GuideService();
class GuideController {
    async createGuide(req, res) {
        try {
            const guide = await guideService.createGuide(req.body);
            res.status(201).json(guide);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async getGuides(req, res) {
        try {
            const guides = await guideService.getGuides();
            res.json(guides);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async getGuideById(req, res) {
        try {
            const guide = await guideService.getGuideById(req.params.id);
            if (!guide) {
                res.status(404).json({ message: "Guide not found" });
                return;
            }
            res.json(guide);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async updateGuide(req, res) {
        try {
            const guide = await guideService.updateGuide(req.params.id, req.body);
            res.json(guide);
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
    async deleteGuide(req, res) {
        try {
            await guideService.deleteGuide(req.params.id);
            res.json({ message: "Guide deleted successfully" });
        }
        catch (error) {
            if (error instanceof Error) {
                res.status(500).json({ message: error.message });
            }
            else {
                res.status(500).json({ message: "An unknown error occurred" });
            }
        }
    }
}
exports.GuideController = GuideController;
//# sourceMappingURL=guideController.js.map