import { Request, Response, NextFunction } from 'express';
import { DocumentService } from '../../services/admin/documentService';
interface CustomRequest extends Request {
    user?: {
        id: string;
        role: string;
    };
}
export declare class DocumentController {
    private documentService;
    constructor(documentService: DocumentService);
    uploadDocument(req: CustomRequest, res: Response, next: NextFunction): Promise<void>;
    getDocumentsForLead(req: Request, res: Response, next: NextFunction): Promise<void>;
    deleteDocument(req: Request, res: Response, next: NextFunction): Promise<void>;
}
export {};
//# sourceMappingURL=documentController.d.ts.map