"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLeadFunnel = exports.getTopSales = exports.getTopAgents = exports.getDashboardData = void 0;
const dashboardService_1 = require("../../services/admin/dashboardService");
const dashboardService = new dashboardService_1.DashboardService();
const getDashboardData = async (req, res) => {
    try {
        const dashboardData = await dashboardService.getDashboardData();
        res.status(200).json({ success: true, data: dashboardData });
    }
    catch (error) {
        console.error("Controller Error - getDashboardData:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
exports.getDashboardData = getDashboardData;
// Add this handler to your dashboard controller
const getTopAgents = async (req, res) => {
    try {
        const limit = parseInt(req.query.limit) || 5;
        const data = await dashboardService.getTopAgents(limit);
        res.status(200).json({
            success: true,
            data,
        });
    }
    catch (error) {
        console.error("Controller Error - getTopAgents:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch top agents",
        });
    }
};
exports.getTopAgents = getTopAgents;
const getTopSales = async (req, res) => {
    try {
        const limit = parseInt(req.query.limit) || 5;
        const data = await dashboardService.getTopSales(limit);
        res.status(200).json({
            success: true,
            data,
        });
    }
    catch (error) {
        console.error("Controller Error - getTopSales:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch top sales",
        });
    }
};
exports.getTopSales = getTopSales;
const getLeadFunnel = async (req, res) => {
    try {
        // Validate query parameter
        const period = req.query.period;
        let validPeriod = 'all'; // Default value
        if (period === '30d' || period === '90d') {
            validPeriod = period;
        }
        const data = await dashboardService.getLeadFunnelData(validPeriod);
        res.status(200).json(data);
    }
    catch (error) {
        console.log(error); // Pass to global error handler
        res.status(500).json({
            success: false,
            message: error.message || "Failed to fetch lead funnel data",
        });
    }
};
exports.getLeadFunnel = getLeadFunnel;
//# sourceMappingURL=dashboardController.js.map