"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.adminLogin = void 0;
const adminService = __importStar(require("../../services/admin/adminService"));
const adminLogin = async (req, res, next) => {
    try {
        const { email, password } = req.body;
        const { accessToken, refreshToken, admin } = await adminService.adminLogin({
            email,
            password,
        });
        console.log(email, password);
        console.log("Admin Login Successful:", { email, accessToken });
        res.setHeader("x-access-token", accessToken);
        res.setHeader("x-refresh-token", refreshToken);
        res.status(200).json({
            success: true,
            message: "Admin login successful",
            user: {
                // ✅ Change `admin` to `user`
                id: admin.id,
                name: admin.name,
                email: admin.email,
                role: admin.role,
            },
            accessToken,
            refreshToken,
        });
    }
    catch (error) {
        console.error("Admin Login Error:", error);
        next(error); // ✅ Properly pass errors to Express error handler
    }
};
exports.adminLogin = adminLogin;
//# sourceMappingURL=adminController.js.map