"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloudConfig = void 0;
exports.uploadToCloud = uploadToCloud;
// backend/src/config/cloudStorageConfig.ts
const ssh2_1 = require("ssh2");
// const cloudConfig = {
//   host: 'sscloud.sixthstar.org',
//   port: 3263, // Default SSH port
//   username: 'ftpuser',
//   password: 'Yf_8jGFSr%64,pNm',
//   remoteBasePath: '/var/www/html/nextcloud/webim/', // The directory on the server where images will be stored
//   baseUrl: 'https://sscloud.sixthstar.org/webim/', // Base URL for accessing images
// };
const cloudConfig = {
    host: process.env.SSCLOUD_HOST || 'sscloud.sixthstar.org', // Use env variable
    port: parseInt(process.env.SSCLOUD_PORT || '3263', 10), // Use env variable, parse to integer
    username: process.env.SSCLOUD_USER || 'ftpuser', // Use env variable
    password: process.env.SSCLOUD_PASSWORD || 'Yf_8jGFSr%64,pNm', // Use env variable
    remoteBasePath: '/var/www/html/nextcloud/webim/', // The directory on the server where images will be stored
    baseUrl: 'https://sscloud.sixthstar.org/webim/', // Base URL for accessing images
};
exports.cloudConfig = cloudConfig;
async function uploadToCloud(localFilePath, remoteFileName) {
    return new Promise((resolve, reject) => {
        const conn = new ssh2_1.Client();
        conn.on('ready', () => {
            console.log('Client :: ready');
            conn.sftp((err, sftp) => {
                if (err) {
                    console.error("SFTP Connection Error:", err);
                    reject(err);
                    return;
                }
                const remoteFilePath = cloudConfig.remoteBasePath + remoteFileName;
                sftp.fastPut(localFilePath, remoteFilePath, {}, (uploadError) => {
                    if (uploadError) {
                        console.error("SFTP Upload Error:", uploadError);
                        reject(uploadError);
                    }
                    else {
                        console.log('File transferred successfully to ' + remoteFilePath);
                        resolve();
                    }
                    conn.end();
                });
            });
        }).on('error', (err) => {
            console.error("SSH Connection Error:", err);
            reject(err);
        }).on('end', () => {
            console.log('Client :: closed');
        }).connect({
            host: cloudConfig.host,
            port: cloudConfig.port,
            username: cloudConfig.username,
            password: cloudConfig.password
        });
    });
}
//# sourceMappingURL=cloudStorageConfig.js.map