import jwt, { SignOptions } from "jsonwebtoken";
import UserRole from "../interfaces/IUserRole";
import { log } from "console";

export const generateToken = (userId: string, role: UserRole, secret: string,  expiresIn: string | number , teamId?: string) => {
    try {
        console.log("Generating JWT with userId:", userId, "role:", role, "teamId:", teamId);
        
        const options: SignOptions = { expiresIn: expiresIn as SignOptions["expiresIn"] }; 
        return jwt.sign({ userId, role , teamId }, secret, options);
    } catch (error: unknown) {
        if (error instanceof Error) {
            throw new Error(error.message);
        } else {
            throw new Error("An unknown error occurred");
        }
    }
};
















