import { Agent, AgentCredentials } from "../../interfaces/Agent";

declare global {
    namespace Express {
        interface Request {
            file?: Express.Multer.File;
            user?: {
                id: string;
                role: string;
            };
            body: {
                id?: string;
                agentCode?: string;
                companyName?: string;
                contactPerson?: string;
                designation?: string;
                companyAddress?: string;
                state?: string;
                email?: string;
                phone?: string;
                markup?: string; // Expecting markup as string in body
                agentPrivilege?: string; // Expecting agentPrivilege as string in body
                credentialsId?: string;
                username?: string;
                password?: string;
                filename?: string;

            } & Request['body'];
        }
    }
}