// File: backend/src/services/user/documentService.ts

import { DocumentRepository } from '../../repositories/user/documentRepository';
import { Document } from '../../interfaces/Document';

export class DocumentService {
  private documentRepository: DocumentRepository;

  constructor(documentRepository: DocumentRepository) {
    this.documentRepository = documentRepository;
  }

  public async createDocument(documentData: Document): Promise<Document> {
    try {
      return await this.documentRepository.createDocument(documentData);
    } catch (error) {
      console.error('Error creating document in service:', error);
      throw error;
    }
  }

  public async getDocumentsForLead(leadId: string): Promise<Document[]> {
    try {
      return await this.documentRepository.getDocumentsForLead(leadId);
    } catch (error) {
      console.error('Error getting documents for lead in service:', error);
      throw error;
    }
  }

  public async deleteDocument(documentId: string): Promise<void> {
    try {
      await this.documentRepository.deleteDocument(documentId);
    } catch (error) {
      console.error('Error deleting document in service:', error);
      throw error;
    }
  }
}