import { LeadStage, LeadStatus } from "@prisma/client";
import { Lead } from "../../interfaces/Lead";
import { AgentLeadRepository } from "../../repositories/agent/AgentLeadRepository";

export class AgentLeadService {
  private agentLeadRepository: AgentLeadRepository;

  constructor(agentLeadRepository: AgentLeadRepository) {
    this.agentLeadRepository = agentLeadRepository;
  }

  public async createLead(leadData: Lead): Promise<Lead> {
    try {
      const newLead = await this.agentLeadRepository.createLead(leadData);
      console.log("New lead created by agent:", newLead);
      return newLead;
    } catch (error) {
      console.error("Error creating lead in agent service:", error);
      throw error;
    }
  }

  async getLeads(agentId: string): Promise<Lead[]> {
    try {
      const leads = await this.agentLeadRepository.getAgentLeads(agentId);
      return leads;
    } catch (error) {
      console.error("Error getting leads in agent service:", error);
      throw error;
    }
  }

  public async getLeadById(
    leadId: string,
    agentId: string
  ): Promise<Lead | null> {
    try {
      const lead = await this.agentLeadRepository.getLeadById(leadId, agentId);
      return lead;
    } catch (error) {
      console.error("Error getting lead by ID in agent service:", error);
      throw error;
    }
  }

  public async updateLead(
    leadId: string,
    agentId: string,
    leadData: Partial<Lead>
  ): Promise<Lead | null> {
    try {
      const updatedLead = await this.agentLeadRepository.updateLead(
        leadId,
        agentId,
        leadData
      );
      return updatedLead;
    } catch (error) {
      console.error("Error updating lead in agent service:", error);
      throw error;
    }
  }

  public async deleteLead(leadId: string, agentId: string): Promise<void> {
    try {
      await this.agentLeadRepository.deleteLead(leadId, agentId);
    } catch (error) {
      console.error("Error deleting lead in agent service:", error);
      throw error;
    }
  }

  public async changeStatus(id: string, status: LeadStatus): Promise<Lead | null> {
          return await this.agentLeadRepository.updateLeadStatus(id, status);
        }
        
        public async changeStage(
          id: string,
          stage: LeadStage,
          userName?: string,
          notes?: string
        ): Promise<Lead | null> {
          return await this.agentLeadRepository.updateLeadStage(id, stage, userName, notes);
        }
}
