import { RestaurantRepository } from "../../repositories/admin/restaurantrepository";

export class RestaurantService {
  private restaurantRepository: RestaurantRepository;

  constructor() {
    this.restaurantRepository = new RestaurantRepository();
  }

  async createRestaurant(data: any) {
    try {
      return await this.restaurantRepository.createRestaurant(data);
    } catch (error) {
      console.error("Error creating restaurant in service:", error);
      throw error; // Re-throw the error to be handled by the controller
    }
  }

  async getRestaurants() {
    try {
      return await this.restaurantRepository.getRestaurants();
    } catch (error) {
      console.error("Error getting restaurants in service:", error);
      throw error; // Re-throw the error to be handled by the controller
    }
  }

  async getRestaurantById(id: string) {
    try {
      return await this.restaurantRepository.getRestaurantById(id);
    } catch (error) {
      console.error("Error getting restaurant by ID in service:", error);
      throw error; // Re-throw the error to be handled by the controller
    }
  }

  async updateRestaurant(id: string, data: any) {
    try {
      return await this.restaurantRepository.updateRestaurant(id, data);
    } catch (error) {
      console.error("Error updating restaurant in service:", error);
      throw error; // Re-throw the error to be handled by the controller
    }
  }

  async deleteRestaurant(id: string) {
    try {
      await this.restaurantRepository.deleteRestaurant(id);
    } catch (error) {
      console.error("Error deleting restaurant in service:", error);
      throw error; // Re-throw the error to be handled by the controller
    }
  }
}
