import { QuotationStatus } from '@prisma/client';
import { QuotationRepository } from '../../repositories/admin/quotationRepository';



export class QuotationService {
  private quotationRepository: QuotationRepository;

  constructor(quotationRepository: QuotationRepository) {
    this.quotationRepository = quotationRepository;
  }
  async createQuotation(data: any,userName:string) {
    try {
      const quotation = await this.quotationRepository.createQuotation(data,userName);
      console.log("Quotation created in service:", quotation);
      return quotation;
    } catch (error) {
      console.error("Service error while creating quotation:", error);
      throw error;
    }
  }
  

  async getQuotationById(id: string) {
    try {
      return await this.quotationRepository.getQuotationById(id);
    } catch (error) {
      console.error("Service error:", error);
    }
  }
  async getQuotationByLeadRefNo(leadRefNo: string) {
    try{
      console.log("LeadRefNo in service", leadRefNo);
      const quotation = await this.quotationRepository.getQuotationByLeadRefNo(leadRefNo);
      console.log("Quotation in service", quotation);
      return quotation;
    } catch(error) {
      console.error("Error in QuotationService.getQuotationByLeadRefNo:", error);
      throw new Error("Failed to fetch quotation by lead reference number");
    }
  }

  async getAllQuotations() {
    try {
      const quotations = await this.quotationRepository.getAllQuotations();
   
      return quotations;
    } catch (error) {
      console.error("Error in QuotationService.getAllQuotations:", error);
      throw new Error("Failed to fetch quotations");
    }
  }

  async updateQuotation(id: string, data: any) {
    const response = await this.quotationRepository.updateQuotation(id, data);
    console.log("Response in Service layer update", response);
    return response;
  }

  async deleteQuotation(id: string) {
    const response= await this.quotationRepository.deleteQuotation(id);
    return response;
  }
 async updateQuotationStatus(id: string, status: QuotationStatus, userName: string) {
  try {
    const updated = await this.quotationRepository.updateQuotationStatus(id, status, userName);
    return updated;
  } catch (error) {
    console.error("Service: Failed to update status", error);
    throw error;
  }
}

 async getAcceptedQuotationsByLeadId  (leadId: string) {
  try {
    return await this.quotationRepository.getAcceptedQuotationsByLeadId(leadId);
  } catch (error) {
    throw error;
  }
}  

async duplicateQuotation(id: string , userName:string) {
  try {
    const quotation = await this.quotationRepository.duplicateQuotation(id,userName);
    return quotation;
  } catch (error) {
    console.error("Service error while duplicating quotation:", error);
    throw error;
  } 
}

}
