import { Omit } from "utility-types"; // Import the Omit type
import { Package } from "../../interfaces/Package";
import { PackageRepository } from "../../repositories/admin/packageRepository";

export class PackageService {
  private packageRepository: PackageRepository;

  constructor(packageRepository: PackageRepository) {
    this.packageRepository = packageRepository;
  }

  // backend/src/services/packageService.ts
  public async createPackage(packageData: Omit<Package, "id">): Promise<Package> {
    try {
      const newPackage = await this.packageRepository.createPackage(
        packageData
      );
      return newPackage;
    } catch (error) {
      console.error("Error creating package in service:", error);
      throw error;
    }
  }

  public async updatePackage(
    packageId: string,
    packageData: Partial<Package>
  ): Promise<Package> {
    try {
      const updatedPackage = await this.packageRepository.updatePackage(
        packageId,
        packageData
      );
      return updatedPackage;
    } catch (error) {
      console.error("Error updating package in service:", error);
      throw error;
    }
  }

  public async getAllPackages(): Promise<Package[]> {
    try {
      const packages = await this.packageRepository.getAllPackages();
      return packages;
    } catch (error) {
      console.error("Error getting packages in service:", error);
      throw error;
    }
  }

  public async getPackageById(packageId: string): Promise<Package | null> {
    try {
      const packageItem = await this.packageRepository.getPackageById(
        packageId
      );
      return packageItem;
    } catch (error) {
      console.error("Error getting package by ID in service:", error);
      throw error;
    }
  }

  public async deletePackage(packageId: string): Promise<void> {
    try {
      await this.packageRepository.deletePackage(packageId);
    } catch (error) {
      console.error("Error deleting package in service:", error);
      throw error;
    }
  }
}
