import { HotelRepository } from "../../repositories/admin/hotelRepository";

export class HotelService {
  private hotelRepository: HotelRepository;

  constructor(hotelRepository: HotelRepository) {
    this.hotelRepository = hotelRepository;
  }

  async createHotel(data: any) {
    return await this.hotelRepository.createHotel(data);
  }

  async getHotels(page = 1, limit = 10, searchTerm = "") {
    return await this.hotelRepository.getHotels(page, limit, searchTerm);
  }
  
  

  async getHotelById(id: string) {
    return await this.hotelRepository.getHotelById(id);
  }

  async updateHotel(id: string, data: any) {
    return await this.hotelRepository.updateHotel(id, data);
  }

  async deleteHotel(id: string) {
    return await this.hotelRepository.deleteHotel(id);
  }
  async createRoom(data: any) {
    if (!data.name || !data.hotelId) {
      throw new Error("Room name and hotel ID are required");
    }
    const room= await this.hotelRepository.createRoom(data);
    return room;
  }

  async updateRoom(id: string, data: any) {
    if (!id || !data) throw new Error("Room ID and data are required");
    return await this.hotelRepository.updateRoom(id, data);
  }

  async deleteRoom(id: string) {
    if (!id) throw new Error("Room ID is required");
    return await this.hotelRepository.deleteRoom(id);
  }
  async getRoomById(id: string) { 
    if (!id) throw new Error("Room ID is required");
    return await this.hotelRepository.getRoomById(id);
  }


  async getRoomsByHotelId(hotelId: string) {
    if (!hotelId) throw new Error('Hotel ID is required');
    return await this.hotelRepository.getRoomsByHotelId(hotelId);
  }
}
