import { Attraction } from "../../interfaces/Attraction";
import { AttractionRepository } from "../../repositories/admin/attractionRepository";

export class AttractionService {
    private attractionRepository: AttractionRepository;

    constructor() {
        this.attractionRepository = new AttractionRepository();
    }

    async createAttraction(data: Attraction) {
        try {
            return await this.attractionRepository.createAttraction(data);
        }
        catch (error:any) {
            console.error("Error creating attraction in service:", error);
            throw new Error(error.message || "Error creating attraction");
        }
    }

    async getAttractions() {
        return await this.attractionRepository.getAttractions();
    }

    async getAttractionById(id: string) {
        return await this.attractionRepository.getAttractionById(id);
    }

    async updateAttraction(id: string, data: Attraction) {
        return await this.attractionRepository.updateAttraction(id, data);
    }

    async deleteAttraction(id: string) {
        return await this.attractionRepository.deleteAttraction(id);
    }
}
