import bcrypt from "bcryptjs";
import dotenv from "dotenv";
import UserRole from "../../interfaces/IUserRole";
import * as adminRepository from "../../repositories/admin/adminRepository";
import { generateToken } from "../../utils/generateJwt";

// Load environment variables
dotenv.config();

const SECRET_KEY = process.env.JWT_SECRET as string;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET as string;

export const adminLogin = async ({
  email,
  password,
}: {
  email: string;
  password: string;
}) => {
  const admin = await adminRepository.getAdminByEmail(email);
  if (!admin) throw new Error("Admin not found");

  const passwordMatch = await bcrypt.compare(password, admin.password);
  if (!passwordMatch) throw new Error("Invalid credentials");

  if (!admin.role) throw new Error("Admin role is missing");

  // Generate access and refresh tokens
  const accessToken = generateToken(
    admin.id.toString(),
    admin.role as UserRole,
    SECRET_KEY,
    "7d"
  );
  const refreshToken = generateToken(
    admin.id.toString(),
    admin.role as UserRole,
    REFRESH_SECRET,
    "14d"
  );

  console.log("Generated Tokens:", { accessToken, refreshToken });

  return { accessToken, refreshToken, admin };
};
