// File: backend/src/repositories/user/documentRepository.ts

import prisma from '../../config/prismaClient';
import { Document } from '../../interfaces/Document';

export class DocumentRepository {
  public async createDocument(documentData: Document): Promise<Document> {
    try {
      const newDocument = await prisma.document.create({
        data: {
          ...documentData,
          updatedAt: new Date().toISOString(), // Ensure updatedAt is provided
        },
      });
      return newDocument;
    } catch (error) {
      console.error('Error creating document in repository:', error);
      throw error;
    }
  }

  public async getDocumentsForLead(leadId: string): Promise<Document[]> {
    try {
      const documents = await prisma.document.findMany({
        where: {
          leadId: leadId,
        },
      });
      return documents;
    } catch (error) {
      console.error('Error getting documents for lead in repository:', error);
      throw error;
    }
  }

  public async deleteDocument(documentId: string): Promise<void> {
    try {
      await prisma.document.delete({
        where: {
          id: documentId,
        },
      });
    } catch (error) {
      console.error('Error deleting document in repository:', error);
      throw error;
    }
  }
}