import prisma from "../../config/prismaClient";

export class TeamRepository {
  async createDefaultTeams() {
    const defaultTeams = ["lead", "operation", "assessment", "finance"];

    for (const teamName of defaultTeams) {
      // Check if the team already exists
      const existingTeam = await prisma.team.findUnique({
        where: { name: teamName },
      });

      if (!existingTeam) {
        // Create the team if it doesn't exist
        await prisma.team.create({
          data: { name: teamName },
        });
        console.log(`Team '${teamName}' created.`);
      }
    }
    console.log("All default teams are set up.");
  }

  async getTeams() {
    return await prisma.team.findMany();
  }

  async deleteTeamById(teamId: string) {
    try {
      await prisma.team.delete({
        where: { id: teamId },
      });
      console.log(`Team with ID '${teamId}' deleted.`);
    } catch (error) {
      console.error(`Error deleting team with ID '${teamId}':`, error);
      throw new Error("Team not found or cannot be deleted.");
    }
  }
}
