import { nanoid } from "nanoid";
import prisma from "../../config/prismaClient";

export class SupplierRepository {
  async createSupplier(data: any) {
    return await prisma.suppliers.create({
      data: { id: nanoid(24), ...data },
    });
  }

  async getSuppliers() {
    return await prisma.suppliers.findMany();
  }

  async getSupplierById(id: string) {
    return await prisma.suppliers.findUnique({ where: { id } });
  }

  async updateSupplier(id: string, data: any) {
    return await prisma.suppliers.update({ where: { id }, data });
  }

  async deleteSupplier(id: string) {
    return await prisma.suppliers.delete({ where: { id } });
  }
}
