// server/src/repositories/admin/guideRepository.ts
import { PrismaClient } from '@prisma/client';
import { nanoid } from 'nanoid';

const prisma = new PrismaClient();

export class GuideRepository {
    async createGuide(data: any) {
        return await prisma.guide.create({
            data: {
                id: nanoid(24),
                name: data.name,
                phone: data.phone,
                email: data.email,
                description: data.description,
                termsAndConditions: data.termsAndConditions,
                supplierId: data.supplierId,
                GuidePrice: {
                    create: data.GuidePrice.map((price: any) => ({
                        id: nanoid(24),
                        costPrice: price.costPrice,
                        optionalPrice: price.optionalPrice,
                        paxType: price.paxType,
                        category:price.category
                    })),
                },
            },
            include: {
                GuidePrice: true,
            },
        });
    }

    async getGuides() {
        return await prisma.guide.findMany({
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }

    async getGuideById(id: string) {
        return await prisma.guide.findUnique({
            where: { id },
            include: {
                Suppliers: true,
                GuidePrice: true,
            },
        });
    }
async updateGuide(id: string, data: any) {
    // Step 1: Delete old prices
    await prisma.guidePrice.deleteMany({
        where: { guideId: id },
    });

    // Step 2: Update guide basic info and recreate prices
    return await prisma.guide.update({
        where: { id },
        data: {
            name: data.name,
            phone: data.phone,
            email: data.email,
            description: data.description,
            termsAndConditions: data.termsAndConditions,
            supplierId: data.supplierId,
            GuidePrice: {
                create: data.GuidePrice.map((price: any) => ({
                    id: nanoid(24),
                    costPrice: price.costPrice,
                    optionalPrice: price.optionalPrice,
                    paxType: price.paxType,
                    category: price.category
                })),
            },
        },
        include: {
            GuidePrice: true,
        },
    });
}


    async deleteGuide(id: string) {
        return await prisma.guide.delete({
            where: { id },
            include: {
                GuidePrice: true,
            },
        });
    }
}