import { Request, Response } from "express";
import { AssessmentDashboardService } from "../../services/user/assessmentDashboardService";

const assessmentDashboardService = new AssessmentDashboardService();    

export const getAssessmentDashboardData = async (req: Request, res: Response) => {
    try {
        const userId = (req as any).currentUser;  // Get user ID from authentication middleware

        const dashboardData = await assessmentDashboardService.getDashboardData(userId);
        res.status(200).json({ success: true, data: dashboardData });
    } catch (error: any) {
        console.error("Controller Error - getAssessmentDashboardData:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};

export const getAssessmentLeadOverview = async (req: Request, res: Response) => {
    try {
        const timeframe = (req.params.timeframe as string) || "weekly";
        const userId = (req as any).currentUser;  // Get user ID from authentication middleware

        const bookingLeadOverviewData = await assessmentDashboardService.getAssessmentLeadOverview(timeframe, userId);
        res.status(200).json({ success: true, data: bookingLeadOverviewData });
    } catch (error: any) {
        console.error("Controller Error - getBookingLeadOverview:", error);
        res.status(500).json({
            success: false,
            message: error.message || "Internal Server Error",
        });
    }
};
