import { Request, Response, NextFunction } from "express";
import { UserDashboardService } from "../../services/user/UserTeamDashboardService";

export class UserDashboardController {
  private userDashboardService: UserDashboardService;

  constructor(userDashboardService: UserDashboardService) {
    this.userDashboardService = userDashboardService;
  }

  public async getUserDashboardData(
    req: Request,
    res: Response,
    next: NextFunction
  ): Promise<void> {
    try {
      // Extract from decoded JWT
      const teamId = req.decoded?.teamId;
      const empCode = req.decoded?.userId;
 console.log("Decoded JWT:", req.decoded);
      console.log("Team ID:", teamId, "Employee Code:", empCode);
 const role = req.decoded?.role; 

console.log("User Role:", role);
      if (!teamId ) {
        res.status(400).json({
          success: false,
          message: "Missing teamId",
        });
        return;
    }
        if (!empCode) {
            res.status(400).json({
            success: false,
            message: "Missing empCode in token",
            });
            return;
        }

      const dashboardData = await this.userDashboardService.getDashboardData(
        teamId,
        empCode
      );

      res.status(200).json({ success: true, data: dashboardData });
    } catch (error) {
      console.error("Controller Error - getUserDashboardData:", error);
      next(error); // Use next to send to global error handler
    }
  }
}
