// backend/src/controllers/agentLoginController.ts

import console from "console";
import { NextFunction, Request, Response } from "express";
import { agentLogin } from "../../services/agent/agentLoginService";

export const agentLoginController = async (
  req: Request,
  res: Response,
  next: NextFunction
): Promise<void> => {
  try {
    const { username, password } = req.body;

    if (!username || !password) {
      res.status(400).json({
        success: false,
        message: "Username and password are required.",
      });
      return;
    }

    const { accessToken, refreshToken, credentials } = await agentLogin({
      username,
      password,
    });

    const agent = credentials.agent;

    console.log("🧾 Full AgentCredentials in controller:", credentials);

    res.status(200).json({
      success: true,
      message: "Agent login successful.",
      accessToken,
      refreshToken,
      user: {
        id: agent?.id,
        name: agent?.companyName || agent?.contactPerson || agent?.email,
        email: agent?.email,
        role: agent?.role,
        phone: agent?.phone,
        agentCode: agent?.agentCode,
        contactPerson: agent?.contactPerson,
        // markup: agent?.markup,
        companyName: agent?.companyName,
        companyAddress: agent?.companyAddress,
        designation: agent?.designation,
        state: agent?.state,
        // Include credentials info in response
        credentials: {
          id: credentials.id,
          username: credentials.username,
          filename: credentials.filename,
          password: credentials.password, // Optional: omit this if sensitive
        },
      },
    });
  } catch (error) {
    
    console.error("🚨 Agent login error:", error);
    next(error);
  }
};
