import { NextFunction, Request, Response } from "express";
import * as adminService from "../../services/admin/adminService";

export const adminLogin = async (
  req: Request,
  res: Response,
  next: NextFunction
): Promise<void> => {
  try {
    const { email, password } = req.body;
    const { accessToken, refreshToken, admin } = await adminService.adminLogin({
      email,
      password,
    });

    console.log(email, password);
    console.log("Admin Login Successful:", { email, accessToken });

    res.setHeader("x-access-token", accessToken);
    res.setHeader("x-refresh-token", refreshToken);

    res.status(200).json({
      success: true,
      message: "Admin login successful",
      user: {
        // ✅ Change `admin` to `user`
        id: admin.id,
        name: admin.name,
        email: admin.email,
        role: admin.role,
      },
      accessToken,
      refreshToken,
    });
  } catch (error) {
    console.error("Admin Login Error:", error);
    next(error); // ✅ Properly pass errors to Express error handler
  }
};
