// backend/src/config/cloudStorageConfig.ts
import { Client } from 'ssh2';
import fs from 'fs';
import path from 'path';
import { rejects } from 'assert';

// const cloudConfig = {
//   host: 'sscloud.sixthstar.org',
//   port: 3263, // Default SSH port
//   username: 'ftpuser',
//   password: 'Yf_8jGFSr%64,pNm',
//   remoteBasePath: '/var/www/html/nextcloud/webim/', // The directory on the server where images will be stored
//   baseUrl: 'https://sscloud.sixthstar.org/webim/', // Base URL for accessing images
// };

const cloudConfig = {
    host: process.env.SSCLOUD_HOST || 'sscloud.sixthstar.org', // Use env variable
    port: parseInt(process.env.SSCLOUD_PORT || '3263', 10), // Use env variable, parse to integer
    username: process.env.SSCLOUD_USER || 'ftpuser', // Use env variable
    password: process.env.SSCLOUD_PASSWORD || 'Yf_8jGFSr%64,pNm', // Use env variable
    remoteBasePath: '/var/www/html/nextcloud/webim/', // The directory on the server where images will be stored
    baseUrl: 'https://sscloud.sixthstar.org/webim/', // Base URL for accessing images
  };

async function uploadToCloud(localFilePath: string, remoteFileName: string): Promise<void> {
  return new Promise((resolve, reject) => {
      const conn = new Client();
      conn.on('ready', () => {
          console.log('Client :: ready');
          conn.sftp((err: any, sftp: { fastPut: (arg0: string, arg1: string, arg2: {}, arg3: (uploadError: any) => void) => void; }) => {
              if (err) {
                  console.error("SFTP Connection Error:", err);
                  reject(err);
                  return;
              }

              const remoteFilePath = cloudConfig.remoteBasePath + remoteFileName;

              sftp.fastPut(localFilePath, remoteFilePath, {}, (uploadError: any) => {
                  if (uploadError) {
                      console.error("SFTP Upload Error:", uploadError);
                      reject(uploadError);
                  } else {
                      console.log('File transferred successfully to ' + remoteFilePath);
                      resolve();
                  }
                  conn.end();
              });
          });
      }).on('error', (err: any) => {
          console.error("SSH Connection Error:", err);
          reject(err);
      }).on('end', () => {
          console.log('Client :: closed');
      }).connect({
          host: cloudConfig.host,
          port: cloudConfig.port,
          username: cloudConfig.username,
          password: cloudConfig.password
      });
  });
}

export { cloudConfig, uploadToCloud };