import prisma from "../src/config/prismaClient.js"
import bcrypt from "bcryptjs";

const seedAdmin = async () => {
  try {
    const existingAdmin = await prisma.admin.findUnique({
      where: { email: "admin@ssworld.com" },
    });

    if (!existingAdmin) {
      const hashedPassword = await bcrypt.hash("admin@123", 10);
      await prisma.admin.create({
        data: {
          name: "Admin",
          email: "admin@ssworld.com",
          password: hashedPassword,
          role: "admin",
        },
      });
      console.log("✅ Default Admin Created!");
    } else {
      console.log("✅ Default Admin Already Exists!");
    }
  } catch (error) {
    console.error("❌ Error seeding admin:", error);
  } finally {
    await prisma.$disconnect();
  }
};

seedAdmin();
