-- CreateTable
CREATE TABLE "Admin" (
    "id" SERIAL NOT NULL,
    "name" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "password" TEXT NOT NULL,
    "role" TEXT NOT NULL,

    CONSTRAINT "Admin_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Suppliers" (
    "id" TEXT NOT NULL,
    "companyName" TEXT NOT NULL,
    "category" TEXT,
    "contactPerson" TEXT,
    "designation" TEXT,
    "email" TEXT NOT NULL,
    "contactNo" TEXT NOT NULL,
    "companyAddress" TEXT,

    CONSTRAINT "Suppliers_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Hotels" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "location" TEXT,
    "starRating" TEXT,
    "tourismTax" TEXT,
    "stateTax" TEXT,
    "address" TEXT,
    "phone" TEXT,
    "description" TEXT,
    "termsAndConditions" TEXT,
    "supplierId" TEXT NOT NULL,
    "surcharge" JSONB,
    "closedDates" JSONB,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "Hotels_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Room" (
    "id" TEXT NOT NULL,
    "hotelId" TEXT NOT NULL,
    "category" TEXT,
    "pax" INTEGER,
    "costPrice" DOUBLE PRECISION,
    "optionalPrice" DOUBLE PRECISION,
    "pricePerNight" DOUBLE PRECISION,
    "extraBedAdult" DOUBLE PRECISION,
    "extraBedChild" DOUBLE PRECISION,
    "breakfastAdult" DOUBLE PRECISION,
    "breakfastChild" DOUBLE PRECISION,
    "surcharge" DOUBLE PRECISION,
    "maxPax" INTEGER,
    "extraBeds" INTEGER,

    CONSTRAINT "Room_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "HotelPrice" (
    "id" TEXT NOT NULL,
    "hotelId" TEXT NOT NULL,
    "category" TEXT,
    "pax" TEXT,
    "costPrice" DOUBLE PRECISION,
    "optionalPrice" DOUBLE PRECISION,

    CONSTRAINT "HotelPrice_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Vehicle" (
    "id" TEXT NOT NULL,
    "transferId" TEXT NOT NULL,
    "vehicle" TEXT,
    "pax" TEXT,
    "price" DOUBLE PRECISION,
    "optionalPrice" DOUBLE PRECISION,
    "minPax" INTEGER,
    "maxPax" INTEGER,

    CONSTRAINT "Vehicle_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Transfer" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "from" TEXT,
    "to" TEXT,
    "supplierId" TEXT NOT NULL,
    "terms" TEXT,
    "updatedAt" TIMESTAMP(3),

    CONSTRAINT "Transfer_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Attraction" (
    "id" TEXT NOT NULL,
    "supplierId" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "location" TEXT NOT NULL,
    "description" TEXT NOT NULL,
    "terms" TEXT,
    "surchargeDates" TIMESTAMP(3)[],
    "closedDates" TIMESTAMP(3)[],
    "applyFridays" BOOLEAN NOT NULL,
    "applySaturdays" BOOLEAN NOT NULL,
    "applySundays" BOOLEAN NOT NULL,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Attraction_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "AttractionPrice" (
    "id" TEXT NOT NULL,
    "category" TEXT NOT NULL,
    "paxType" TEXT NOT NULL,
    "costPrice" DECIMAL(65,30) NOT NULL,
    "optionalPrice" DECIMAL(65,30),
    "attractionId" TEXT NOT NULL,

    CONSTRAINT "AttractionPrice_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "User" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "mobile" TEXT NOT NULL,
    "password" TEXT,
    "empCode" TEXT NOT NULL,
    "empId" TEXT NOT NULL,
    "teamId" TEXT NOT NULL,
    "agentPrivilege" BOOLEAN NOT NULL DEFAULT false,
    "inactive" BOOLEAN DEFAULT false,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,

    CONSTRAINT "User_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Team" (
    "id" TEXT NOT NULL,
    "name" TEXT NOT NULL,

    CONSTRAINT "Team_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "AgentCredentials" (
    "id" TEXT NOT NULL,
    "username" TEXT,
    "password" TEXT,
    "filename" TEXT,

    CONSTRAINT "AgentCredentials_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Agent" (
    "id" TEXT NOT NULL,
    "agentCode" TEXT NOT NULL,
    "companyName" TEXT NOT NULL,
    "contactPerson" TEXT NOT NULL,
    "designation" TEXT NOT NULL,
    "companyAddress" TEXT NOT NULL,
    "state" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "phone" TEXT NOT NULL,
    "markup" DOUBLE PRECISION NOT NULL,
    "agentPrivilege" BOOLEAN NOT NULL,
    "credentialsId" TEXT,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL,
    "deleted" BOOLEAN NOT NULL DEFAULT false,

    CONSTRAINT "Agent_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "Admin_email_key" ON "Admin"("email");

-- CreateIndex
CREATE UNIQUE INDEX "User_email_key" ON "User"("email");

-- CreateIndex
CREATE UNIQUE INDEX "Team_name_key" ON "Team"("name");

-- CreateIndex
CREATE UNIQUE INDEX "Agent_credentialsId_key" ON "Agent"("credentialsId");

-- AddForeignKey
ALTER TABLE "Hotels" ADD CONSTRAINT "Hotels_supplierId_fkey" FOREIGN KEY ("supplierId") REFERENCES "Suppliers"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Room" ADD CONSTRAINT "Room_hotelId_fkey" FOREIGN KEY ("hotelId") REFERENCES "Hotels"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "HotelPrice" ADD CONSTRAINT "HotelPrice_hotelId_fkey" FOREIGN KEY ("hotelId") REFERENCES "Hotels"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Vehicle" ADD CONSTRAINT "Vehicle_transferId_fkey" FOREIGN KEY ("transferId") REFERENCES "Transfer"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Transfer" ADD CONSTRAINT "Transfer_supplierId_fkey" FOREIGN KEY ("supplierId") REFERENCES "Suppliers"("id") ON DELETE CASCADE ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Attraction" ADD CONSTRAINT "Attraction_supplierId_fkey" FOREIGN KEY ("supplierId") REFERENCES "Suppliers"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "AttractionPrice" ADD CONSTRAINT "AttractionPrice_attractionId_fkey" FOREIGN KEY ("attractionId") REFERENCES "Attraction"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "User" ADD CONSTRAINT "User_teamId_fkey" FOREIGN KEY ("teamId") REFERENCES "Team"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Agent" ADD CONSTRAINT "Agent_credentialsId_fkey" FOREIGN KEY ("credentialsId") REFERENCES "AgentCredentials"("id") ON DELETE SET NULL ON UPDATE CASCADE;
