"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttractionService = void 0;
const attractionRepository_1 = require("../repositories/attractionRepository");
class AttractionService {
    constructor() {
        this.attractionRepository = new attractionRepository_1.AttractionRepository();
    }
    createAttraction(data) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield this.attractionRepository.createAttraction(data);
            }
            catch (error) {
                console.error("Error creating attraction in service:", error);
                throw new Error(error.message || "Error creating attraction"); // or a more specific error
            }
        });
    }
    getAttractions() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.attractionRepository.getAttractions();
        });
    }
    getAttractionById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.attractionRepository.getAttractionById(id);
        });
    }
    updateAttraction(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.attractionRepository.updateAttraction(id, data);
        });
    }
    deleteAttraction(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.attractionRepository.deleteAttraction(id);
        });
    }
}
exports.AttractionService = AttractionService;
