"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const authMiddleware_1 = require("../middlewares/authMiddleware");
const roleMiddleware_1 = require("../middlewares/roleMiddleware");
const adminController_1 = require("../controllers/adminController");
const hotelController_1 = require("../controllers/hotelController");
const supplierController_1 = require("../controllers/supplierController");
const transferController_1 = require("../controllers/transferController");
const attractionController_1 = require("../controllers/attractionController"); // Import Attraction Controller
const hotelController = new hotelController_1.HotelController();
const supplierController = new supplierController_1.SupplierController();
const transferController = new transferController_1.TransferController();
const attractionController = new attractionController_1.AttractionController(); // Create Attraction Controller Instance
const adminRouter = express_1.default.Router();
// Admin Authentication Routes
adminRouter.post("/login", adminController_1.adminLogin);
// Admin Dashboard Route
adminRouter.get("/dashboard", authMiddleware_1.authenticateUser, (0, roleMiddleware_1.authorizeRole)(["admin"]), (req, res) => {
    res.json({ message: "Welcome Admin!" });
});
// Hotel Management
adminRouter.post("/createHotel", hotelController.createHotel);
adminRouter.get("/hotels", hotelController.getHotels);
adminRouter.get("/getHotel/:id", hotelController.getHotelById);
adminRouter.put("/updateHotel/:id", hotelController.updateHotel);
adminRouter.delete("/deleteHotel/:id", hotelController.deleteHotel);
// Supplier management
adminRouter.post("/createSupplier", (req, res) => supplierController.createSupplier(req, res));
adminRouter.get("/suppliers", (req, res, next) => {
    supplierController.getSuppliers(req, res).catch(next);
});
adminRouter.get("/getSupplier/:id", (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        yield supplierController.getSupplierById(req, res);
    }
    catch (error) {
        next(error); // Pass the error to the next middleware
    }
}));
adminRouter.put("/updateSupplier/:id", (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        yield supplierController.updateSupplier(req, res);
    }
    catch (error) {
        next(error); // Pass the error to the next middleware
    }
}));
adminRouter.delete("/deleteSupplier/:id", (req, res) => supplierController.deleteSupplier(req, res));
// Transfer management
adminRouter.post("/createTransfer", transferController.createTransfer);
adminRouter.get("/transfers", transferController.getTransfers);
adminRouter.get("/getTransfer/:id", transferController.getTransferById);
adminRouter.put("/updateTransfer/:id", transferController.updateTransfer);
adminRouter.delete("/deleteTransfer/:id", transferController.deleteTransfer);
// Attraction management
adminRouter.post("/attractions", (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        yield attractionController.createAttraction(req, res, next);
    }
    catch (error) {
        next(error);
    }
}));
adminRouter.get("/attractions", attractionController.getAttractions);
adminRouter.get("/attraction/:id", attractionController.getAttractionById);
adminRouter.put("/attraction/:id", attractionController.updateAttraction);
adminRouter.delete("/attraction/:id", attractionController.deleteAttraction);
exports.default = adminRouter;
