"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelRepository = void 0;
const prismaClient_js_1 = __importDefault(require("../config/prismaClient.js"));
const nanoid_1 = require("nanoid");
class HotelRepository {
    createHotel(data) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_js_1.default.hotels.create({
                    data: Object.assign({ id: (0, nanoid_1.nanoid)(24) }, data),
                });
            }
            catch (error) {
                console.error("Error creating hotel:", error);
                throw new Error("Failed to create hotel");
            }
        });
    }
    getHotels() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_js_1.default.hotels.findMany();
            }
            catch (error) {
                console.error("Error fetching hotels:", error);
                throw new Error("Failed to fetch hotels");
            }
        });
    }
    getHotelById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_js_1.default.hotels.findUnique({ where: { id } });
            }
            catch (error) {
                console.error(`Error fetching hotel with ID ${id}:`, error);
                throw new Error("Failed to fetch hotel");
            }
        });
    }
    updateHotel(id, data) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_js_1.default.hotels.update({ where: { id }, data });
            }
            catch (error) {
                console.error(`Error updating hotel with ID ${id}:`, error);
                throw new Error("Failed to update hotel");
            }
        });
    }
    deleteHotel(id) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield prismaClient_js_1.default.hotels.delete({ where: { id } });
            }
            catch (error) {
                console.error(`Error deleting hotel with ID ${id}:`, error);
                throw new Error("Failed to delete hotel");
            }
        });
    }
}
exports.HotelRepository = HotelRepository;
