"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authorizeRole = void 0;
const authorizeRole = (allowedRoles) => {
    return (req, res, next) => {
        if (!req.currentUserRole || !allowedRoles.includes(req.currentUserRole)) {
            res.status(403).json({ success: false, message: "Access denied: Insufficient permissions" });
            return;
        }
        next();
    };
};
exports.authorizeRole = authorizeRole;
