"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticateUser = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const generateJwt_1 = require("../utils/generateJwt");
require("../types/express"); // Ensure Express types are extended
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
const SECRET_KEY = process.env.JWT_SECRET;
const REFRESH_SECRET = process.env.JWT_REFRESH_SECRET;
const authenticateUser = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const authorizationHeader = req.headers.authorization;
        let refreshTokenHeader = req.headers["x-refresh-token"];
        if (!authorizationHeader) {
            res.status(403).json({ success: false, message: "Access token is missing" });
            return;
        }
        const token = authorizationHeader.split(" ")[1];
        try {
            const decoded = jsonwebtoken_1.default.verify(token, SECRET_KEY);
            console.log(decoded);
            if (decoded && decoded.userId && decoded.role) {
                req.currentUser = decoded.userId;
                req.currentUserRole = decoded.role;
                return next();
            }
            res.status(403).json({ success: false, message: "Invalid token" });
            return;
        }
        catch (error) {
            if (error.name === "TokenExpiredError" && refreshTokenHeader) {
                // ✅ Ensure refreshTokenHeader is a string
                if (Array.isArray(refreshTokenHeader)) {
                    refreshTokenHeader = refreshTokenHeader[0]; // Take the first value
                }
                if (typeof refreshTokenHeader !== "string") {
                    res.status(403).json({ success: false, message: "Invalid refresh token format" });
                    return;
                }
                try {
                    const refreshDecoded = jsonwebtoken_1.default.verify(refreshTokenHeader, REFRESH_SECRET);
                    if (refreshDecoded && refreshDecoded.userId && refreshDecoded.role) {
                        req.currentUser = refreshDecoded.userId;
                        req.currentUserRole = refreshDecoded.role;
                        const newAccessToken = (0, generateJwt_1.generateToken)(refreshDecoded.userId, refreshDecoded.role, SECRET_KEY, "1h");
                        res.setHeader("x-access-token", newAccessToken);
                        return next();
                    }
                    res.status(403).json({ success: false, message: "Invalid refresh token" });
                    return;
                }
                catch (refreshError) {
                    res.status(403).json({ success: false, message: "Invalid or expired refresh token" });
                    return;
                }
            }
            else {
                res.status(403).json({ success: false, message: "Invalid access token" });
                return;
            }
        }
    }
    catch (error) {
        console.error("Authentication Error:", error);
        res.status(403).json({ success: false, message: "Unauthorized access" });
        return;
    }
});
exports.authenticateUser = authenticateUser;
