"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransferController = void 0;
const transferService_1 = require("../services/transferService");
const transferService = new transferService_1.TransferService();
class TransferController {
    createTransfer(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const transfer = yield transferService.createTransfer(req.body);
                res.status(201).json(transfer);
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        });
    }
    getTransfers(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const transfers = yield transferService.getTransfers();
                res.json(transfers);
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        });
    }
    getTransferById(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const transfer = yield transferService.getTransferById(req.params.id);
                if (!transfer) {
                    res.status(404).json({ message: "Transfer not found" });
                    return;
                }
                res.json(transfer);
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        });
    }
    updateTransfer(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const transfer = yield transferService.updateTransfer(req.params.id, req.body);
                res.json(transfer);
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        });
    }
    deleteTransfer(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield transferService.deleteTransfer(req.params.id);
                res.json({ message: "Transfer deleted successfully" });
            }
            catch (error) {
                if (error instanceof Error) {
                    res.status(500).json({ message: error.message });
                }
                else {
                    res.status(500).json({ message: "An unknown error occurred" });
                }
            }
        });
    }
}
exports.TransferController = TransferController;
