"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttractionController = void 0;
const attractionService_1 = require("../services/attractionService");
const prismaClient_1 = __importDefault(require("../config/prismaClient")); // Import your Prisma client
class AttractionController {
    constructor() {
        this.createAttraction = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const attraction = req.body;
                // *** DATA VALIDATION HERE!! ****  IMPORTANT!!!
                if (!attraction.name || attraction.name.length < 3) {
                    return res.status(400).json({ message: "Name must be at least 3 characters long." });
                }
                if (!attraction.supplierId) {
                    return res.status(400).json({ message: "Supplier ID is required." });
                }
                // *** VALIDATE SUPPLIER ID ***
                const supplierExists = yield prismaClient_1.default.suppliers.findUnique({
                    where: {
                        id: attraction.supplierId,
                    },
                });
                if (!supplierExists) {
                    return res.status(400).json({ message: "Invalid supplier ID." });
                }
                const createdAttraction = yield this.attractionService.createAttraction(attraction);
                res.status(201).json(createdAttraction);
            }
            catch (error) {
                console.error("Error creating attraction in controller:", error);
                res.status(500).json({ message: error.message || "Internal Server Error" });
            }
        });
        this.getAttractions = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const attractions = yield this.attractionService.getAttractions();
                res.json(attractions);
            }
            catch (error) {
                next(error);
            }
        });
        this.getAttractionById = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const attraction = yield this.attractionService.getAttractionById(req.params.id);
                if (!attraction) {
                    res.status(404).json({ message: "Attraction not found" });
                    return;
                }
                res.json(attraction);
            }
            catch (error) {
                next(error);
            }
        });
        this.updateAttraction = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                const attraction = yield this.attractionService.updateAttraction(req.params.id, req.body);
                res.json(attraction);
            }
            catch (error) {
                next(error);
            }
        });
        this.deleteAttraction = (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.attractionService.deleteAttraction(req.params.id);
                res.json({ message: "Attraction deleted successfully" });
            }
            catch (error) {
                next(error);
            }
        });
        this.attractionService = new attractionService_1.AttractionService();
    }
}
exports.AttractionController = AttractionController;
